<?php
namespace ElementorPro\License;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Updater {

	public $plugin_version;
	public $plugin_name;
	public $plugin_slug;

	public function __construct() {
		$this->plugin_version = ELEMENTOR_PRO_VERSION;
		$this->plugin_name = ELEMENTOR_PRO_PLUGIN_BASE;
		$this->plugin_slug = basename( ELEMENTOR_PRO__FILE__, '.php' );

		$this->init();
	}

	private function init() {
		add_filter( 'pre_set_site_transient_update_plugins', [ $this, 'check_update' ] );
	}

	public function check_update( $_transient_data ) {
		global $pagenow;

		if ( ! is_object( $_transient_data ) ) {
			$_transient_data = new \stdClass;
		}

		if ( 'plugins.php' === $pagenow && is_multisite() ) {
			return $_transient_data;
		}

		$version_info = API::get_version();
		if ( ! is_wp_error( $version_info ) && ! empty( $version_info['new_version'] ) ) {
			if ( version_compare( $this->plugin_version, $version_info['new_version'], '<' ) ) {
				$_transient_data->response[ $this->plugin_name ] = (object) $version_info;
			}

			$_transient_data->last_checked = current_time( 'timestamp' );
			$_transient_data->checked[ $this->plugin_name ] = $this->plugin_version;
		}

		return $_transient_data;
	}
}
